package topdown;

import topdown.operator.Relation;
import topdown.term.FunctionalSymbol;
import topdown.term.Term;

public class Database {
    public Relation r, s, t, u, v;

    public Database() {
        /* declaration of EDB */

        // standard binary relations
        Term[][] rows = {
                {new FunctionalSymbol("a"), new FunctionalSymbol("x")},
                {new FunctionalSymbol("b"), new FunctionalSymbol("y")},
                {new FunctionalSymbol("c"), new FunctionalSymbol("x")},
        };
        r = new Relation(rows);

        Term[][] rowsS = {
                {new FunctionalSymbol("y"), new FunctionalSymbol("x")},
                {new FunctionalSymbol("a"), new FunctionalSymbol("x")},
                {new FunctionalSymbol("d"), new FunctionalSymbol("y")},
        };
        s = new Relation(rowsS);

        // empty relation
        t = new Relation(new Term[][]{});

        // simple relation for recursive ancestor test
        Term[][] rowsU = {
                {new FunctionalSymbol("a"), new FunctionalSymbol("b")},
                {new FunctionalSymbol("b"), new FunctionalSymbol("c")},
        };
        u = new Relation(rowsU);

        // unary relation
        Term[][] rowsV = {
                {new FunctionalSymbol("a")},
                {new FunctionalSymbol("b")},
        };
        v = new Relation(rowsV);
    }

    public Relation getByName(String name) {
        return switch (name) {
            case "r" -> r;
            case "s" -> s;
            case "t" -> t;
            case "u" -> u;
            case "v" -> v;
            default -> throw new IllegalStateException("Unexpected value: " + name);
        };
    }
}
